/*
WndProc, WindowProc example
This example shows how to use the WndProc method and the WindowProc property to subclass a custom controls window procedure.  This example subclasses the window procedure of a TListBox descendant to respond to a user-defined message called WM_STYLEMESSAGE. The subclassed window procedure can be turned on or off by pressing a radio button.
*/ 
void __fastcall TMyListBoxDescendant::SubClassWndProc(Messages::TMessage &Message)
{
  if (Message.Msg == WM_STYLEMESSAGE)
    Style = (TListBoxStyle)Message.WParam;
  else
    WndProc(Message);
}
void __fastcall TMyListBoxDescendant::ToggleSubClass(bool On)
{
  if (On)
    WindowProc = SubClassWndProc;
  else
    WindowProc = WndProc;
}
void __fastcall TForm1::SubClassRadioGroup1Click(TObject *Sender)
{
  MyListBoxDescendant1->ToggleSubClass(SubClassRadioGroup1->ItemIndex == 0);
} 
