//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SysUtilsFileOpen.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SysUtilsFileOpen
// Routine: SysUtils.FileOpen
// Routine: SysUtils.FileSeek
// Routine: SysUtils.FileRead
// Routine: System.AllocMem

// BeginCode
/*
The following example uses a button, a string grid, and an
Open dialog box on a form. When the button is clicked, the
user is prompted for a filename. When the user clicks OK,
the specified file is opened, read into a buffer, and closed.
Then the buffer is displayed in two columns of the string
grid. The first column contains the character values in the
buffer. The second column contains the numeric values of the
characters in the buffer.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int iFileHandle;
  int iFileLength;
  int iBytesRead;
  char *pszBuffer;
  if (OpenDialog1->Execute())
  {
	try
	{
	  iFileHandle = FileOpen(OpenDialog1->FileName, fmOpenRead);
      iFileLength = FileSeek(iFileHandle,0,2);
	  FileSeek(iFileHandle,0,0);
//	  pszBuffer = PChar(AllocMem(iFileLength+1));
	  std::auto_ptr<char> pszBuffer(new char[iFileLength+1]);
	  iBytesRead = FileRead(iFileHandle, pszBuffer.get(), iFileLength);
      FileClose(iFileHandle);
	  for (int i=0;i<iBytesRead;i++)
	  {
        StringGrid1->RowCount += 1;
		StringGrid1->Cells[1][i+1] = pszBuffer.get()[i];
        StringGrid1->Cells[2][i+1] = IntToStr((int)pszBuffer.get()[i]);
      }
	}
    catch(...)
    {
	  Application->MessageBox(
		L"Can't perform one of the following file operations: Open, Seek, Read, Close.",
		L"File Error", IDOK);
    }
  }
}
// EndCode
// EndExample: SysUtilsFileOpen
//---------------------------------------------------------------------------
