/*
StrLen, StrLCat example
The following example uses an edit control and a button on a form in a cross-platform application. When the button is clicked, the edit controls text is split in halves that are copied into separate buffers. Then the contents of the buffers are displayed in a message box.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // The following line is for VCL applications
  AnsiString EditText = AnsiString(Edit1->Text);
  // The following line is for CLX applications
  // AnsiString EditText = WideCharToString(Edit1->Text.c_bstr());
  char* szFirstHalf = new char[StrLen(EditText.c_str())/2+2];
  char* szSecondHalf = new char[StrLen(EditText.c_str())/2+2];
  char* pszSecondHalf = &EditText[StrLen(EditText.c_str())/2+1];

  *szFirstHalf = 0;
  *szSecondHalf = 0;

  StrLCat(szFirstHalf, EditText.c_str(), StrLen(EditText.c_str())/2);
  StrCat(szSecondHalf, pszSecondHalf);

  Application->MessageBox(szFirstHalf, First Half", TMessageButtons() << smbOK, smsInformation, smbOK, smbCancel);
  Application->MessageBox(szSecondHalf, "Second Half", TMessageButtons() << smbOK, smsInformation, smbOK, smbCancel);

  delete [] szFirstHalf;
  delete [] szSecondHalf;
} 
