//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SystemStrLComp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: SysUtilsStrLComp
// Routine: SysUtils.StrLComp

// BeginCode
/*
This example requires two text edits and a button.
Enter text in the two text edits and click the button
to compare the strings.
*/
#include <algorithm> 	// for the min function
#include <memory>       // for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<char> szResult(new char[Edit1->Text.Length() + Edit2->Text.Length() + 65]);
  int len = std::min(Edit1->Text.Length(), Edit2->Text.Length());
  int iResult = Sysutils::StrLComp(
	Edit1->Text.c_str(), Edit2->Text.c_str(), len + 1);
  StrCopy(szResult.get(), "The first ");
  StrCat(szResult.get(), IntToStr(len).t_str());
  StrCat(szResult.get(), " characters of ");
  StrCat(szResult.get(), Edit1->Text.t_str());
  if (iResult < 0)
	StrCat(szResult.get(), " are less than the first ");
  else if (iResult > 0)
	StrCat(szResult.get(), " are greater than the first ");
  else
	StrCat(szResult.get(), " are equal to the first ");
  StrCat(szResult.get(), IntToStr(len).t_str());
  StrCat(szResult.get(), " characters of ");
  StrCat(szResult.get(), Edit2->Text.t_str());

  ShowMessage(szResult.get());
}
// EndCode
// EndExample: SysUtilsStrLComp
//---------------------------------------------------------------------------
