
(*
 Delphi Object and Component Reference
#{bmc bm9.BMP} StrLIComp example
The following example uses two edit controls and a button on a form. When the button is clicked, the first X bytes of the edit controls are compared, where X is the number of characters in the shorter string. To do a case-sensitive compare, use StrLComp instead of StrLIComp.
*) 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  char* szResult = new char[Edit1->Text.Length() + Edit2->Text.Length() + 65];
// the following 2 lines are for VCL applications
  AnsiString Edit1Text = Edit1->Text;
  AnsiString Edit2Text = Edit2->Text;
// the following 2 lines are for CLX applications
//  AnsiString Edit1Text = WideCharToString(Edit1->Text.c_bstr());
//  AnsiString Edit2Text = WideCharToString(Edit2->Text.c_bstr());
  int len = min(Edit1Text.Length(), Edit2Text.Length());
  int iResult = StrLIComp(Edit1Text.c_str(), Edit2Text.c_str(), len);

  StrCopy(szResult, "The first ");
  StrCat(szResult, IntToStr(len).c_str());
  StrCat(szResult, " bytes of ")
  StrCat(szResult, Edit1Text.c_str());
  if (iResult < 0)
    StrCat(szResult, " are less than the first ");
  else if (iResult > 0)
    StrCat(szResult, " are greater than the first ");
  else
    StrCat(szResult, " are equal to the first ");
  StrCat(szResult, IntToStr(len).c_str());
  StrCat(szResult, " bytes of ");
  StrCat(szResult, Edit2Text.c_str());

  ShowMessage(szResult);
  delete [] szResult;
}; 
