//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: System_MoveChars
// Routine: System.GetMemory
// Routine: System.MoveChars
// Routine: System.ReallocMemory
// Routine: System.FreeMemory

// BeginCode
/*
The following code demostrates the use of memory management functions in C++. Three
edit boxes and a button are expected onthe form.
*/
String __fastcall FastStrCat(String s1, String s2)
{
  /*
   Allocated enough space in FinalStr to copy the contents
   of the initial string + $00 character
  */
  wchar_t* finalStr = (wchar_t *)GetMemory((s1.Length() + 1) * sizeof(wchar_t));

  // Copy the contents of the first string
  MoveChars(s1.data(), finalStr, s1.Length() + 1);

  // And now expand the final string + $00 character
  finalStr = (wchar_t *)ReallocMemory(finalStr, (s1.Length() + s2.Length() + 1) * sizeof(wchar_t));

  // Copy the contents of the second string
  MoveChars(s2.data(), finalStr + s1.Length(), s2.Length() + 1);

  // Get the result in String
  String result = String(finalStr);
  FreeMemory(finalStr);

  return result;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // Concatenate 2 string
  Edit3->Text = FastStrCat(Edit1->Text, Edit2->Text);
}
// EndCode
// EndExample: System_MoveChars
//---------------------------------------------------------------------------
