//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TActionOnExecute.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TActionOnExecute
// Event: Classes.TBasicAction.OnExecute

// BeginCode
/*
When a client component or control is clicked, the OnExecute
event occurs for its associated action. For example, the
following code illustrates the OnExecute event handler for
an action that toggles the visibility of a toolbar when the
action is executed. This example requires a TActionList
(with one TAction) and a TToolBar on a form.  Double click
on the TActionList and create an TAction named Action1.  The
TActionList must have no OnExecute event handler, and the
TAction has an OnExecute event handler called Action1Execute.
Then set an object's (such as a button or menu item) Action
to Action1.  Set the TToolbar color to something that will
make it obvious when it is visible.  Also remember to uncheck
Project|Options|Applications|Enable runtime themes.
*/
void __fastcall TMainForm::Action1Execute(TObject *Sender)
{
  // Toggle Toolbar1's visibility
  ToolBar1->Visible = !ToolBar1->Visible;
  if (ToolBar1->Visible)
	lbOther->Items->Add("Event Action1Execute: toolbar visible");
  else
	lbOther->Items->Add("Event Action1Execute: toolbar not visible");
}
// EndCode
// EndExample: TActionOnExecute
//---------------------------------------------------------------------------
