//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TActionOnUpdate.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TActionOnUpdate
// Event: Classes.TBasicAction.OnUpdate
// Property: ActnList.TCustomAction.Checked

// Warning: Button freezes up and never gets to Buton1Click
// Remove Action1 from Button1 Action
// Button doesn't freeze, but does nothing (no listbox, no toolbar vis)
// Close project and double click on button to go to Button1Click
// Rebuild, listbox and toolbar vis toggles!

// BeginCode
/*
When the application is idle, the OnUpdate event occurs for
every action that is linked to a visible control or menu
item that is showing. This provides an opportunity for
applications to execute centralized code for enabling and
disabling, checking and unchecking, and so on. For example,
the following code illustrates the OnUpdate event handler
for an action that is "checked" when the toolbar is visible.
This example requires a TActionList (with one TAction) and a
TToolBar on a form. Double click
on the TActionList and create an TAction named Action1.  The
TAction has an OnUpdate event handler called Action1Update.
Then set an object's (such as a button or menu item) Action
to Action1.
*/
Boolean checked;

void __fastcall TForm1::Action1Update(TObject *Sender)
{
   // Indicate whether ToolBar1 is currently visible.
   TAction* pa = dynamic_cast<TAction*>(Sender);
   if (pa)
   {
	 if (checked != ToolBar1->Visible)
	 {
	   lbOther->Items->Add("Event Action1Update: toolbar visibility changed");
	 }
	 checked = ToolBar1->Visible;
   }
//   pa->Checked = True;  // set this statically and don't change it!
}
// EndCode
// EndExample: TActionOnUpdate

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  // Toggle Toolbar1's visibility
  ToolBar1->Visible = !ToolBar1->Visible;
  if (ToolBar1->Visible)
	lbOther->Items->Add("Event Action1Execute: toolbar visible");
  else
	lbOther->Items->Add("Event Action1Execute: toolbar not visible");
}
//---------------------------------------------------------------------------




