/*
OnUpdate, Checked example
When the application is idle, the OnUpdate event occurs for every action that is linked to a visible control or menu item that is showing. This provides an opportunity for applications to execute centralized code for enabling and disabling, checking and unchecking, and so on. For example, the following code illustrates the OnUpdate event handler for an action that is checked when the toolbar is visible. This example requires a TActionList (with one TAction) and a TToolBar on a form.
*/ 
void __fastcall TForm1::Action1Update(TObject *Sender)
{
   // Indicate whether ToolBar1 is currently visible.
   TAction* pa = dynamic_cast<TAction*>(Sender);
   if (pa)
      pa->Checked = ToolBar1->Visible;
} 
