//---------------------------------------------------------------------------
// BeginExample: TAppCreateForm
// Method: Forms.TApplication.CreateForm
// Method: ComCtrls.TProgressBar.StepBy
// Method: Forms.TApplication.Run
// Method: Forms.TCustomForm.Show
// Method: Controls.TWinControl.Update
// Method: Forms.TApplication.Initialize

// BeginCode
/*
This example shows progress of loading forms as an
application starts up. The code example is placed in the
project source (*_proj.cpp) file. To see project source, right
click on the executable file in the Project Manager and
select the View Source menu item.
You will need to set up your project with the following steps
before using the code example:
o          Add four additional forms to a default project.
o          Place a TProgressBar on Form5
o          Take the Project|Options|Forms menu option and place
			   Form5 on the available forms list.
o          Change the code of your project (*_proj.cpp) file to
			   look like the example.
*/
#include <vcl\vcl.h>
#include "Unit5.h"
#pragma hdrstop
//---------------------------------------------------------------------------
USEFORM("TAppCreateForm.cpp", Form1);
USERES("Project1.res");
USEFORM("Unit2.cpp", Form2);
USEFORM("Unit3.cpp", Form3);
USEFORM("Unit4.cpp", Form4);
USEFORM("Unit5.cpp", Form5);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
  try
  {
    Application->Initialize();
	SetApplicationMainFormOnTaskBar(Application, true);
	Application->CreateForm(__classid(TForm5), &Form5);
	Form5->ProgressBar1->Max = 100;
	Form5->Show();   // show a splash screen contain ProgressBar control
	Form5->Update(); // force display of Form5
	Application->CreateForm(__classid(TForm1), &Form1);
	Form5->ProgressBar1->StepBy(25);
	Form5->Label1->Caption =  "Form1 loaded successfully.";
	Form5->Update(); // force display of Form5
	Sleep(3000);
	Application->CreateForm(__classid(TForm2), &Form2);
	Form5->ProgressBar1->StepBy(25);
	Form5->Label1->Caption =  "Form2 loaded successfully.";
	Form5->Update(); // force display of Form5
	Sleep(3000);
	Application->CreateForm(__classid(TForm3), &Form3);
	Form5->ProgressBar1->StepBy(25);
	Form5->Label1->Caption =  "Form3 loaded successfully.";
	Form5->Update(); // force display of Form5
	Sleep(3000);
	Application->CreateForm(__classid(TForm4), &Form4);
	Form5->ProgressBar1->StepBy(25);
	Form5->Label1->Caption =  "Form4 loaded successfully.";
	Form5->Update(); // force display of Form5
	Sleep(3000);
//	delete Form5;
	Application->Run();
  }
  catch (Exception &exception)
  {
	Application->ShowException(&exception);
  }
  return 0;
}
// EndCode
// EndExample: TAppCreateForm
//---------------------------------------------------------------------------
