/*
StepBy, CreateForm, Run, Show, Update, Initialize example
This example shows progress of loading forms as an application starts up. The code example is placed in the project source (*.dpr) file. To see project source, select the View | Project Source menu item.  
You will need to set up your project with the following steps before using the code example:
                Add four additional forms to a default project. 
                Place a TProgressBar on Form5
                Take the Project|Options|Forms menu option and place Form5 on the available forms list.
                Change the code of your project (*.dpr) file to look like the example.
*/
#include <vcl\vcl.h>
#include "Unit5.h"
#pragma hdrstop
//---------------------------------------------------------------------------
USEFORM("Unit1.cpp", Form1);
USERES("Project1.res");
USEFORM("Unit2.cpp", Form2);
USEFORM("Unit3.cpp", Form3);
USEFORM("Unit4.cpp", Form4);
USEFORM("Unit5.cpp", Form5);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
  try
  {
    Application->Initialize();
    Application->CreateForm(__classid(TForm5), &Form5);
    Form5->ProgressBar1->Max = 100;
    Form5->Show();   // show a splash screen contain ProgressBar control
    Form5->Update(); // force display of Form5
    Application->CreateForm(__classid(TForm1), &Form1);
    Form5->ProgressBar1->StepBy(25);
    Application->CreateForm(__classid(TForm2), &Form2);
    Form5->ProgressBar1->StepBy(25);
    Application->CreateForm(__classid(TForm3), &Form3);
    Form5->ProgressBar1->StepBy(25);
    Application->CreateForm(__classid(TForm4), &Form4);
    	Form5->ProgressBar1->StepBy(25);
    delete Form5;
    Application->Run();
  }
  catch (Exception!AL(`exception_object',1,`TopicNotFound',`main') &exception)
  {
    Application->ShowException(&exception);
  }
  return 0;
}
 
