/*
OpenPictureDialog, Icon example
The following code allows the user to use a dialog box to redefine the icon for the application at run time. When the user clicks Button1, OpenDialog1 executes and the user specifies an icon filename. The Icon is then assigned to the application.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  OpenPictureDialog1->DefaultExt = GraphicExtension(__classid(TIcon));
  OpenPictureDialog1->FileName = GraphicFileMask(__classid(TIcon));
  OpenPictureDialog1->Filter = GraphicFilter(__classid(TIcon));
  OpenPictureDialog1->Options.Clear();
  OpenPictureDialog1->Options << ofFileMustExist << ofHideReadOnly << ofNoChangeDir;
  while (true) 
  {
    if (OpenPictureDialog1->Execute())
    {
      if (!OpenPictureDialog1->Options.Contains(ofExtensionDifferent))
      {
        Application->Icon->LoadFromFile(OpenPictureDialog1->FileName);
        break;
      }
      else // reset Options to remove ofExtensionDifferent
      {
        OpenPictureDialog1->Options.Clear();
        OpenPictureDialog1->Options << ofFileMustExist << ofHideReadOnly << ofNoChangeDir;
      }
    }
    else // user cancelled
      break;
  }
} 
