//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ButtonedEdit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm4 *Form4;
//---------------------------------------------------------------------------

// BeginExample: TButtonedEdit
// Class: ExtCtrls.TButtonedEdit
// Class: ExtCtrls.TEditButton
// Property: ExtCtrls.TCustomButtonedEdit.LeftButton
// Property: ExtCtrls.TCustomButtonedEdit.RightButton
// Property: ExtCtrls.TCustomButtonedEdit.Images
// Event: ExtCtrls.TCustomButtonedEdit.OnLeftButtonClick
// Event: ExtCtrls.TCustomButtonedEdit.OnRightButtonClick
// Property: ExtCtrls.TEditButton.Enabled
// Property: ExtCtrls.TEditButton.ImageIndex
// Property: ExtCtrls.TEditButton.DisabledImageIndex
// Property: ExtCtrls.TEditButton.HotImageIndex

// BeginCode
/*
This example shows how to use the TButtonedEdit class. This example
implements a component like "TButtonedEdit search" that's to be
found in the tool pallete window.
Entering the control will enable the right button, left button will
display a MessageDlg and the right button will clear the input text.
*/
__fastcall TForm4::TForm4(TComponent* Owner)
	: TForm(Owner)
{
	//declaring an instance
	btnEdit = new TButtonedEdit(this);

	//setting the parent so it will autodetele
	btnEdit->Parent = this;

	//positioning
	btnEdit->Left = 10;
	btnEdit->Top = 10;

	//creating a TImageList and using it for the button
	TImageList* imList = new TImageList(this);
	Graphics::TBitmap* bmap = new Graphics::TBitmap();
	bmap->LoadFromFile("..\\littleB_16.bmp");
	imList->Add(bmap,NULL);
	bmap->LoadFromFile("..\\little_logo_16.bmp");
	imList->Add(bmap,NULL);
	btnEdit->Images = imList;

	//selecting the image for the left button and enabling it
	btnEdit->LeftButton->Visible = true;
	btnEdit->LeftButton->Enabled = true;
	btnEdit->LeftButton->ImageIndex = 0;
	btnEdit->LeftButton->DisabledImageIndex = 0;
	btnEdit->LeftButton->HotImageIndex = 0;

	//selecting the image for the right button
	//this will be enabled when the content changes
	btnEdit->RightButton->Enabled = true;
	btnEdit->RightButton->ImageIndex = 1;
	btnEdit->RightButton->DisabledImageIndex = 1;
	btnEdit->RightButton->HotImageIndex = 1;

	//selecting action for the buttoned edit to take
	btnEdit->OnEnter = btnEditEnter;
	btnEdit->OnRightButtonClick = btnEditRightClick;
	btnEdit->OnLeftButtonClick = btnEditLeftClick;

	//default text in the edit
	btnEdit->Text = "Default";

	btnEdit->Constraints->MinHeight = 16;
	btnEdit->Height = 16;

	//finally displaying the button
	btnEdit->Show();

}
//---------------------------------------------------------------------------

void __fastcall TForm4::btnEditEnter(TObject* Sender){
   btnEdit->Text = "";
   btnEdit->RightButton->Visible = true;
}

void __fastcall TForm4::btnEditRightClick(TObject* Sender){
   //resetting to default state
   btnEdit->Text = "Default";
   btnEdit->RightButton->Visible = false;
}

void __fastcall TForm4::btnEditLeftClick(TObject* Sender){
   MessageDlg("Left button pressed with: " + btnEdit->Text,
  			 mtInformation, TMsgDlgButtons() << mbOK, 0);

}

// EndCode
// EndExample: TButtonedEdit
