//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TControlCursor.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: TControlCursor
// Property: Controls.TControl.Cursor
// Property: Forms.TScreen.Cursors
// Property: Forms.TScreen.Cursor

// Warning: A lot like http://delphi.about.com/od/adptips2005/qt/bmp2cur.htm

// BeginCode
/*
This example shows how to add custom cursors to an
application.  The following code makes this cursor available
to the application via the constant crMyCursor, and sets it
as the global cursor to the application.
*/

#include <memory>       //for STL auto_ptr class

const crMyCursor = 5;

  void __fastcall TForm1::Button2Click(TObject *Sender)
{
  std::auto_ptr<Graphics::TBitmap> bmpMask(new Graphics::TBitmap);
  std::auto_ptr<Graphics::TBitmap> bmpColor(new Graphics::TBitmap);
  std::auto_ptr<TIconInfo> iconInfo(new TIconInfo);

  bmpMask->LoadFromFile("../SquareMask.bmp");
  bmpColor->LoadFromFile("../Square.bmp");

  iconInfo->fIcon = false;
  iconInfo->xHotspot = 15;
  iconInfo->yHotspot = 15;
  iconInfo->hbmMask = bmpMask->Handle;
  iconInfo->hbmColor = bmpColor->Handle;

  Screen->Cursors[crMyCursor] = CreateIconIndirect(iconInfo.get());

  Screen->Cursor = crMyCursor;
}
// EndCode
// EndExample: TControlCursor
//---------------------------------------------------------------------------
