/*
Parent, InsertControl, RemoveControl example
This example uses a button  When the user clicks the button, the group box becomes the parent of the button, so the button moves inside the group box.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (Button1->Parent == GroupBox1)
  {
    GroupBox1->RemoveControl(Button1);
    GroupBox2->InsertControl(Button1);
  }
  else
  {
    GroupBox2->RemoveControl(Button1);
    GroupBox1->InsertControl(Button1);
  }
}
/*
Note that it was necessary to remove the button from the Controls property of the form before the button actually moves into the group box.
This code accomplishes the same thing:
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (Button1->Parent == GroupBox1)
    Button1->Parent = GroupBox2;
  else
    Button1->Parent = GroupBox1;
} 
