/*
CountrolCount, Controls, Top example
This example uses an updown control (Windows-only components) or a scroll bar (cross-platform components) and a group box on a form, with several controls contained within the group box. When the updown control or  is clicked, the controls within the group box are moved in the appropriate direction.
Windows example:
*/
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
  int I;
  TControl *ChildControl;

  for (I = 0; I < GroupBox1->ControlCount; I++)
  {
    ChildControl = GroupBox1->Controls[I];
    if (Button == btNext) 
      ChildControl->Top = ChildControl->Top + 15;
    else
      ChildControl->Top = ChildControl->Top - 15;
  }
}
/*
Cross-platform example:
*/
void __fastcall TForm1::ScrollBar1Scroll(TObject *Sender, TScrollCode ScrollCode, int &ScrollPos)
{
  for (int i = 0; i < GroupBox1->ControlCount; i++)
  {
    TControl *ChildControl = GroupBox1->Controls[i];
    ChildControl->Top = ChildControl->Tag + ScrollPos;
  }
} 
