//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TCoolBarBands.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TCoolBarBands
// Property: ComCtrls.TCoolBar.Bands
// Property: ComCtrls.TCoolBands.Items
// Property: ComCtrls.TCoolBand.Text
// Method: System.TObject.ClassName
// Method: System.TObject.ClassType

// BeginCode
/*
To run this example, add the example code to a new project.
The example code dynamically creates a TCoolbar and three
TCoolBand objects populated with a windowed control in each
TCoolBand.
*/
void AddBands(TCoolBar *CoolBar, TList *Objects)
{
  TControl *pCurrent;
  for (int i = 0; i < Objects->Count; i++)
  {
	pCurrent = reinterpret_cast<TControl *>(Objects->Items[i]);
    // only add windowed controls to the coolbar
    if (dynamic_cast<TWinControl *>(pCurrent) != NULL)
    {
	  // Placing the control onto the CoolBar
      // causes the TCoolBar object to create a TCoolBand 
	  // and place the control within the band.
	  pCurrent->Parent = CoolBar;   // This statement increments CoolBar->Bands->Count.
	  // Get the reference of the TCoolBand just created and assign text.
	  String S = pCurrent->ClassName();
	  CoolBar->Bands->Items[CoolBar->Bands->Count - 1]->Text = S;
	}
  }
}

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TCoolBar *CoolBar = new TCoolBar(this); // The Ownder (Form1) will clean this up.
  CoolBar->Parent = this;
  CoolBar->Align = alTop;
  std::auto_ptr<TList> List(new TList);
  try
  {
	TControl *Control;
	Control = new TButton(CoolBar); // The Ownder (CoolBar) will clean this up.
	List->Add(Control);
	Control = new TCheckBox(CoolBar); // The Ownder (CoolBar) will clean this up.
	List->Add(Control);
	Control = new TEdit(CoolBar); // The Ownder (CoolBar) will clean this up.
	List->Add(Control);
	AddBands(CoolBar, List.get());
  }
  catch (...)
  {
    ShowMessage("Some objects could not be added to Coolband");
  }
}
// EndCode
// EndExample: TCoolBarBands
//---------------------------------------------------------------------------
