/*
Bands, Items, Text example
To run this example, add the example code to a new project. The example code dynamically creates a TCoolbar and three TCoolBand objects populated with a windowed control in each TCoolBand.
*/ 
void AddBands(CoolBar: TCoolBar, TList *Objects)
{
  TControl *pCurrent;
  for (int i = 0; i < Objects->Count; i++)
  {
    pCurrent = (TControl *)Objects->Items[i];
    // only add windowed controls to the coolbar
    if (dynamic_cast<TWinControl *>(pCurrent) != NULL)
    {
      // Placing the control onto the CoolBar 
      // causes the TCoolBar object to create a TCoolBand 
      // and place the control within the band.
      pCurrent->Parent = Coolbar;
      // Get the reference of the TCoolBand just created and assign text.
      CoolBar->Bands->Items[CoolBar->Bands->Count - 1]->Text =
          pCurrent->ClassName;
    }
  }
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TCoolBar *pCoolBar = new TCoolBar(this);
  TList *pList;
  pCoolBar->Parent = this;
  CoolBar->Align = alTop;
  pList = new TList();
  try
  {
    TControl *pControl;
    pControl = new TButton(CoolBar);
    pList->Add(pControl);
    pControl = new TCheckBox(CoolBar);
    pList->Add(pControl);
    pControl = new TEdit(CoolBar);
    pList->Add(pControl);
    AddBands(CoolBar, pList);
  }
  catch (...)
  {
    ShowMessage("Some objects could not be added to Coolband");
  }
  delete pList;
}
 
