//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DBTables.hpp"
#include "TDataSetAfterDelete.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TForm1 *Form1;
TTable *Table1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TDataSetAfterDelete
// Event: DB.TDataSet.AfterDelete
// Routine: SysUtils.Format
// Routine: AnsiStrings.Format

// BeginCode
/*
This example displays a message on the forms status bar
indicating the record count after a record is deleted.  Set
the StatusBar SimplePanel property to True.
*/
void __fastcall TForm1::Table1AfterDelete(TDataSet *DataSet)
{
  StatusBar1->SimpleText = Format(
	"There are now %d records in the table",
	ARRAYOFCONST(((int)DataSet->RecordCount)));
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Table1->Delete();
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Table1 = new TTable(Form1);
  Table1->Active = false; // The Table component must not be active
  Table1->DatabaseName = "DBDEMOS";
  Table1->TableType = ttParadox;
  Table1->TableName = "CustInfo";
  Table1->Active = False;
  if (!Table1->Exists) // Don't overwrite an existing table
  {
	Table1->Close();
	Table1->DeleteTable();
  }
  // The Table component must not be active
  // First, describe the type of table and give
  // it a name
  // Next, describe the fields in the table
  Table1->FieldDefs->Clear();
  TFieldDef *pNewDef = Table1->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field1";
  pNewDef->DataType = ftInteger;
  pNewDef->Required = true;
  pNewDef = Table1->FieldDefs->AddFieldDef();
  pNewDef->Name = "Field2";
  pNewDef->DataType = ftString;
  pNewDef->Size = 30;
  // Next, describe any indexes
  Table1->IndexDefs->Clear();
  /* the 1st index has no name because it is a Paradox primary key */
  Table1->IndexDefs->Add("","Field1", TIndexOptions() <<ixPrimary << ixUnique);
  Table1->IndexDefs->Add("Fld2Index","Field2", TIndexOptions() << ixCaseInsensitive);
  // Now that we have specified what we want, create the table
  Table1->CreateTable();
  Table1->Active = True;
  for (int i = 1; i <= 20; i++)
	Table1->AppendRecord(ARRAYOFCONST((i*111, i*222)));
  DS2->DataSet = Table1;
  DBGrid2->DataSource->DataSet = Table1;
  Table1->AfterDelete = Table1AfterDelete;
  Table1->Active = True;
}
// EndCode
// EndExample: TDataSetAfterDelete
//---------------------------------------------------------------------------

