//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TListAdd.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TListAdd
// Method: Classes.TList.Add
// Property: Classes.TList.Count
// Property: Classes.TList.Items

// BeginCode
/*
This example creates a list object and inserts two records
into it. The value of the record fields are written on a
paintbox:
*/

#include <memory>       //for STL auto_ptr class

typedef struct AList
{
  int I;
  char C;
} TAList;

typedef TAList* PAList;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<TList> MyList(new TList);
  // fill the TList
  std::auto_ptr<TAList> AStruct1(new TAList);
  AStruct1->I = 100;
  AStruct1->C = 'Z';
  MyList->Add(AStruct1.get());
  std::auto_ptr<TAList> AStruct2(new TAList);
  AStruct2->I = 200;
  AStruct2->C = 'X';
  MyList->Add(AStruct2.get());
  
  // Go through the list, writing the elements to the
  // canvas of a paintbox component.
  int Y = 10; // position on canvas
  for (int i = 0; i < MyList->Count; i++)
  {
	TAList *AStruct = (PAList) MyList->Items[i];
    PaintBox1->Canvas->TextOut(10, Y, IntToStr(AStruct->I));
    Y += 30;  // Increment Y Value again
    PaintBox1->Canvas->TextOut(10, Y, AStruct->C);
    Y += 30;  //Increment Y Value
  }
}
// EndCode
// EndExample: TListAdd
//---------------------------------------------------------------------------
