//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TListIndexOf.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TListIndexOf
// Method: Classes.TList.Remove
// Method: Classes.TList.IndexOf
// Method: Graphics.TCanvas.TextOut

// BeginCode
/*
The following code adds an object to MyList if it isnt
already in the list.
*/

#include <memory>       //for STL auto_ptr class

typedef struct AList
{
  int I;
  char C;
} TAList;

typedef AList* PAList;

TList *MyList;
PAList ARecord1, ARecord2;

void __fastcall DisplayTList(TList *theList)
{
  PAList AStruct;
  // Go through the list, writing the elements to the
  // canvas of a paintbox component.
  int Y = 10; // position on canvas
  for (int i = 0; i < theList->Count; i++)
  {
	AStruct = (PAList) theList->Items[i];
	Form1->PaintBox1->Canvas->TextOut(10, Y, IntToStr(AStruct->I));
	Y += 30;  // Increment Y Value again
	Form1->PaintBox1->Canvas->TextOut(10, Y, AStruct->C);
	Y += 30;  //Increment Y Value
  }
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (MyList->IndexOf(ARecord1) == -1) MyList->Add(ARecord1);
  DisplayTList(MyList);
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (MyList->IndexOf(ARecord2) == -1) MyList->Add(ARecord2);
  DisplayTList(MyList);
}

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  if (MyList->Count != 0)
  {
	for (int B = MyList->Count - 1; B >= 0; B--)
	{
	  PAList ARecord;
	  ARecord = PAList(MyList->Items[B]);
	  MyList->Remove(ARecord);
	}
  }
  Form1->PaintBox1->Repaint();
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  static std::auto_ptr<TList> _MyListCleaner(MyList = new TList);
  static std::auto_ptr<TAList> _ARecord1Cleaner(ARecord1 = new TAList);
  ARecord1->I = 100;
  ARecord1->C = 'Z';
  static std::auto_ptr<TAList> _ARecord2Cleaner(ARecord2 = new TAList);
  ARecord2->I = 200;
  ARecord2->C = 'X';
}
// EndCode
// EndExample: TListIndexOf
//---------------------------------------------------------------------------

