//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TListLast.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TListLast
// Method: Classes.TList.Last

// BeginCode
/*
This example inserts two records into a list object and
displays the contents of the last record in the list on the form:
*/

#include <memory>       //for STL auto_ptr class

typedef struct AList
{
  int I;
  char C;
} TAList;

typedef AList* PAList;

TList *MyList;
PAList ARecord1, ARecord2;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  PAList ARecord = reinterpret_cast<AList *>(MyList->Last());
  PaintBox1->Canvas->TextOut(10, 10, IntToStr(ARecord->I)); // Display I
  PaintBox1->Canvas->TextOut(10, 40, ARecord->C); // Display C
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  Refresh();
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  static std::auto_ptr<TList> _MyListCleaner(MyList = new TList);
  static std::auto_ptr<TAList> _ARecord1Cleaner(ARecord1 = new TAList);
  ARecord1->I = 100;
  ARecord1->C = 'Z';
  MyList->Add(ARecord1);
  static std::auto_ptr<TAList> _ARecord2Cleaner(ARecord2 = new TAList);
  ARecord2->I = 200;
  ARecord2->C = 'X';
  MyList->Add(ARecord2);
}
// EndCode
// EndExample: TListLast
//---------------------------------------------------------------------------
