/*
OnColumnClick, AlphaSort, OnCompare, CompareText example
This example shows how to use the OnColumnClick and OnCompare events of a list view to let users sort the columns in a report-style list view by clicking on the column headers. This requires a global variable to keep track of the column that was clicked:
*/ 
int ColumnToSort = 0;

The OnColumnClick event handler sets the global variable to indicate the column to sort and calls AlphaSort:
*) 
void __fastcall TForm1::ListView1ColumnClick(TObject *Sender, TListColumn *Column)
{
  ColumnToSort = Column->Index;
  ((TCustomListView *)Sender)->AlphaSort();
}

The OnCompare event handler causes the list view to sort on the selected column:

void __fastcall TForm1.ListView1Compare(TObject *Sender, TListItem *Item1, TListItem *Item2, int Data, int &Compare)
{
  if (ColumnToSort == 0)
    Compare = CompareText(Item1->Caption,Item2->Caption);
  else
  {
    int ix = ColumnToSort  1;
    Compare = 
      CompareText(Item1->SubItems->Strings[ix], Item2->SubItems->Strings[ix]);
  }
}
Note:	This OnCompare event handler uses the global CompareText function. An application may want to use AnsiCompareText, CompareStr, or AnsiCompareStr instead, depending on whether the comparison should be case-sensitive and whether the locale should be considered. 
