//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TMetafileCreate.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TMetafileCreate
// Property: Graphics.TMetafile.Create
// Method: Graphics.TMetafileCanvas.Create

// BeginCode
/*
This example shows how to create or augment a metafile using
a metafile canvas object.  This metafile can then be used to
draw on the canvas of another object such as a paintbox or a
printer.
*/
#include <memory>       //for STL auto_ptr class

TMetafile *MyMetafile;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  static std::auto_ptr<TMetafile> _MyMetafileCleaner(MyMetafile = new TMetafile());
  TMetafileCanvas *canvas = new TMetafileCanvas(MyMetafile, 0);
  canvas->Brush->Color = clRed;
  canvas->Ellipse(0, 0, 100, 200);
  // ...
  delete canvas;
  Form1->Canvas->Draw(0, -50, MyMetafile); //1 red circle
  PaintBox1->Canvas->Draw(0, 0, MyMetafile); //1 red circle
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (MyMetafile == NULL) return;   // click Button1 first!
  TMetafileCanvas *canvas = new TMetafileCanvas(MyMetafile, 0);
  canvas->Draw(-50, 0, MyMetafile);
  canvas->Brush->Color = clBlue;
  canvas->Ellipse(100, 100, 300, 200);
  // ...
  delete canvas; // TMetaFile canvas paints in the destructor.
  Form1->Canvas->Draw(0, 0, MyMetafile); // 1 red circle and 1 blue circle
  PaintBox1->Canvas->Draw(0, 0, MyMetafile); // 1 red circle and 1 blue circle
}
// EndCode
// EndExample: TMetafileCreate
//---------------------------------------------------------------------------
