//--------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TOleContainerExample.h"
//--------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//--------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//--------------------------------------------------------------------

// BeginExample: TOleContainer
// Method: OleCtnrs.TOleContainer.CreateObjectFromFile
// Method: OleCtnrs.TOleContainer.SaveAsDocument
// BeginCode
/*
This example uses an OLE container and a main menu on a form.
When the user clicks the Open or Save options in the main menu,
an open/save dialog is displayed and by default,
the user is required to enter the name of a Word document.
Files with other extensions supported by the OLE container
can also be accessed. An additional test is made to assure that
the file to open exists and that no file overwriting is
going to take place.
*/
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  Close();
}

void __fastcall TForm1::Open1Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
    if (FileExists(OpenDialog1->FileName))
      OleContainer1->CreateObjectFromFile(OpenDialog1->FileName, false);
    else
      throw(Exception("File not found."));
}

void __fastcall TForm1::Save1Click(TObject *Sender)
{
  if (SaveDialog1->Execute())
    if (FileExists(SaveDialog1->FileName))
      throw(Exception("File already exists. Cannot overwrite."));
  else
    OleContainer1->SaveAsDocument(SaveDialog1->FileName);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  OpenDialog1->Filter = "Documents (*.doc)|*.DOC|Any file (*.*)|*.*";
  SaveDialog1->Filter = "Documents (*.doc)|*.DOC|Any file (*.*)|*.*";
}
// EndCode
// EndExample: TOleContainer

//--------------------------------------------------------------------

