/*
Printing example
This example uses a button, a Page Control, and a Print dialog box on a form. When the user clicks the button, the print dialog is displayed. The user can select any subset of the pages in the page control for printing.  The selected pages are then printed.
To run this example successfully, you must include <Printers.hpp> in your unit file.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  PrintDialog1->Options.Clear();
  PrintDialog1->Options << poPageNums << poSelection;
  PrintDialog1->FromPage = 1;
  PrintDialog1->MinPage = 1;
  PrintDialog1->ToPage = PageControl1->PageCount;
  PrintDialog1->MaxPage = PageControl1->PageCount;
  if (PrintDialog1->Execute())
  {
    int Start, Stop;
    // determine the range the user wants to print
    switch (PrintDialog1->PrintRange)
    {
      case prSelection:
        Start = PageControl1->ActivePage->PageIndex;
        Stop = Start;
        break;
      case prPageNums:
        Start = PrintDialog1->FromPage - 1;
        Stop =  PrintDialog1->ToPage - 1;
        break;
      default:  // prAllPages
        Start = PrintDialog1->MinPage - 1;
        Stop = PrintDialog1->MaxPage - 1;
        break;
    }
    // now, print the pages 
    Printer()->BeginDoc();
    for (int i = Start; i <= Stop; i++)
    {
      PageControl1->Pages[i]->PaintTo(Printer()->Handle, 10, 10);
      if (i != Stop)
        Printer()->NewPage();
    }
    Printer()->EndDoc();
  }
} 
