//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TProgressBarStepIt.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TProgressBarStepIt
// Property: ComCtrls.TProgressBar.Step
// Method: ComCtrls.TProgressBar.StepIt

// BeginCode
/*
This example reads bytes from a file in tenths of the size
of the file. The ProgressBar displays the status of each
1/10th step as it's read into the buffer.  This example
requires a TButton and a TProgressBar control on the form.
*/
#include <stdio.h>     // for FILE, fopen, fstat, fileno, fread and fclose
#include <sys\stat.h>  // for fstat and the stat struct
#include <Math.hpp>    // for Min
#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FILE *F;
  char MyData[2047];
  long BytesRead;

  F = fopen("../about.txt", "r");   // path relative to Debug
									// use a file larger than 2048 bytes to make it interesting.
  if (F)
  {
	struct stat statbuf;
	fstat(fileno(F), &statbuf);
    ProgressBar1->Max = statbuf.st_size;
	if (ProgressBar1->Max > 10)
	{
	  ProgressBar1->Step = (ProgressBar1->Max)/10;
	  ProgressBar1->Step = Min(ProgressBar1->Step, 2047);
	}
	else
	  ProgressBar1->Step = ProgressBar1->Max;
	std::auto_ptr<char> DataBuffer(new char[ProgressBar1->Step]);
	for (ProgressBar1->Position = 0;
		 ProgressBar1->Position < ProgressBar1->Max;
		 ProgressBar1->StepIt())  // move the ProgressBar Position using StepIt
	{
	  fread(DataBuffer.get(), ProgressBar1->Step, 1, F);
	  // Do this or the read will wrap and start over!
	  ProgressBar1->Step =
		Min(ProgressBar1->Step, ProgressBar1->Max - ProgressBar1->Position);
	}
    fclose(F);
  }
}
// EndCode
// EndExample: TProgressBarStepIt
//---------------------------------------------------------------------------
