/*
Step, StepIt example
This example reads bytes from a file in tenths of the size of the file. The ProgressBar displays the status of each  1/10th step as it's read into the buffer.  
The example assumes a TButton and a TProgressBar control already placed on the form.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  FILE *F;
  // On Windows replace, myfile with a pathname such as c:\autoexec.bat
  F = fopen("MyFile.txt", "r");
  if (F)
  {
    struct stat statbuf;
    fstat(fileno(F), &statbuf);
    ProgressBar1->Max = statbuf.st_size;
    if (ProgressBar1->Max > 10) 
      ProgressBar1->Step = (ProgressBar1->Max)/10;
    else
      ProgressBar1->Step = ProgressBar1->Max;
    char *DataBuffer = new char[ProgressBar1->Step];
    for (ProgressBar1->Position = 0;
         ProgressBar1->Position < ProgressBar1->Max;
         ProgressBar1->StepIt())
    {
      fread(DataBuffer, ProgressBar1->Step, 1, F);
      // do something with the next chunk
    }
    delete DataBuffer;
    fclose(F);
  }
}
 
