//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RegExampleCPP.h"
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TRegistry
// Class: Registry.TRegistry
// Method: Registry.TRegistry.Create
// Method: Registry.TRegistry.KeyExists
// Method: Registry.TRegistry.OpenKey
// Method: Registry.TRegistry.WriteDateTime
// Method: Registry.TRegistry.WriteString
// Method: Registry.TRegistry.WriteExpandString
// Method: Registry.TRegistry.CloseKey
// Method: Registry.TRegistry.DeleteKey
// Property: Registry.TRegistry.RootKey
// Property: Registry.TRegistry.Access

// BeginCode
/*
This example shows how to use the TRegistry class in order to
find, insert and delete Keys and Items into the Windows Registry.
This example uses two buttons: InsertToRegBtn and DeleteFromRegBtn,
for inserting and deleting the values.
*/
void __fastcall TForm2::InsertToRegBtnClick(TObject *Sender)
{
	TRegistry* reg = new TRegistry(KEY_READ);
	reg->RootKey = HKEY_LOCAL_MACHINE;

	if(!reg->KeyExists("Software\\MyCompanyName\\MyApplication\\"))
	{
		MessageDlg("Key not found! Created now.",
					mtInformation, TMsgDlgButtons() << mbOK, 0);
	}
	reg->Access = KEY_WRITE;
	bool openResult = reg->OpenKey("Software\\MyCompanyName\\MyApplication\\", true);

	if(!openResult)
	{
		MessageDlg("Unable to create key! Exiting.",
					mtError, TMsgDlgButtons() << mbOK, 0);
		return;
	}
	//checking if the values exist and inserting when neccesary

	if(!reg->KeyExists("Creation\ Date"))
	{
		TDateTime today = TDateTime::CurrentDateTime();
		reg->WriteDateTime("Creation\ Date", today);
	}

	if(!reg->KeyExists("Licenced\ To"))
	{
		reg->WriteString("Licenced\ To", "MySurname\ MyFirstName");
	}

	if(!reg->KeyExists("App\ Location"))
	{
		reg->WriteExpandString("App\ Location",
								"%PROGRAMFILES%\\MyCompanyName\\MyApplication\\");
	}

	if(!reg->KeyExists("Projects\ Location"))
	{
		reg->WriteExpandString("Projects\ Location",
								"%USERPROFILE%\\MyApplication\\Projects\\");
	}

	reg->CloseKey();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::DelFromRegBtnClick(TObject *Sender)
{
	//deleting the example registry entries
	TRegistry* reg = new TRegistry(KEY_WRITE);
	reg->RootKey = HKEY_LOCAL_MACHINE;

	reg->DeleteKey("Software\\MyCompanyName\\MyApplication");
	reg->DeleteKey("Software\\MyCompanyName");

	reg->CloseKey();
}
//---------------------------------------------------------------------------
// EndCode
// EndExample: TRegistry


