﻿//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "StringBuilder.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
#include <vcl.h>
#pragma hdrstop

#include <Sysutils.hpp>
#include <memory>

// BeginExample: TStringBuilder
// Class: SysUtils.TStringBuilder

// BeginCode
/*
This example exercises many of the members of the TStringBuilder class.
*/
template <class T>
void testAppend(T t)
{
	std::auto_ptr<TStringBuilder> builder(new TStringBuilder());
	builder->Append(t);
	UnicodeString s1 = builder->ToString();
	UnicodeString s2(t);
	assert(s1 == s2);
}


#if defined(_DELPHI_STRING_UNICODE)
const wchar_t* ext_chars =
	L"А Б В Г Д Є Ж Ѕ З И І"
	L"К Л М Н О П Ҁ Р С Т Ѹ"
	L"Ф Х Ѡ Ц Ч Ш Щ Ъ Ы Ь Ѣ"
	L"Ю ІА Ѧ Ѩ Ѫ Ѭ Ѯ Ѱ Ѳ Ѵ Ѥ";
#else
const char* ext_chars =
	"À Á Â Ã Ä Å Æ Ç È É Ê Ë Ì Í Î Ï"
	"Ð Ñ Ò Ó Ô Õ Ö × Ø Ù Ú Û Ü Ý Þ ß"
	"à á â ã ä å æ ç è é ê ë ì í î ï"
	"ð ñ ò ó ô õ ö ÷ ø ù ú û ü ý þ ÿ";
#endif

//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	{
		// Test starts out as empty
		std::auto_ptr<TStringBuilder> builder(new TStringBuilder());
		assert(builder->ToString() == System::String());
	}

	{
		// Append
		short s = 0xffe;
		testAppend(s);

		unsigned short us = 0xfffe;
		testAppend(us);
	}

	{
		const _DCHAR* p = ext_chars;

		std::auto_ptr<TStringBuilder> builder(new TStringBuilder());
		System::String str1(p);

		// Appending of wchar_t
		while (*p) 
		{
			builder->Append(*p++);
		}

		// Length property
		assert(builder->Length == str1.Length());

		// Subscript operator
		for (int i=0; i<str1.Length(); i++)
		{
			// NOTE: strings are 1-based
			assert((*(builder.get()))[i] == str1[i+1]);
		}

		// ToString()
		System::String str2 = builder->ToString();
		Edit1->Text = str1;
		Edit2->Text = str2;
		assert(str2 == str1);

		// Replace
		builder->Replace(' ', '.');
		UnicodeString str3;
		str3 = builder->ToString();
		Edit3->Text = str3;
		assert(str3 != str2);

		// Replace back
		builder->Replace(L'.', L' ');
		System::String str4 = builder->ToString();
		Edit4->Text = str4;
		assert(str2 == str4);
	}

	{
		System::String str(ext_chars);

		std::auto_ptr<TStringBuilder> builder(new TStringBuilder());

		// Insert at start when empty, at start when not empty and at end
		builder->Insert(0, str);
		builder->Insert(0, str);
		builder->Insert(builder->Length, str);

		// Concatenate string 3 times
		System::String str2;
		str2 += str;
		str2 += str;
		str2 += str;

		str = builder->ToString();

		Edit5->Text = str;
		assert(builder->ToString() == str2);
	}
	MessageDlg("All assertions passed in the TStringBuilder Test test.",
		mtInformation, TMsgDlgButtons() << mbOK, 0);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
	const _DCHAR* p = ext_chars;

	std::auto_ptr<TStringBuilder> builder(new TStringBuilder());

	// Appending of chars
	while (*p) 
	{
		builder->Append(*p++);
	}

	System::String str1(ext_chars);
	System::String str2 = builder->ToString();
	assert(str1 == str2);

	builder->Replace(_D(" "), _D("."));
	System::String str3;
	str3 = builder->ToString();
	assert(str1 != str3);

	builder->Replace(_D("."), _D(" "));
	System::String str4(builder->ToString());
	assert(str1 == str4);
	MessageDlg("All assertions passed in the TStringBuilder Replace test.",
		mtInformation, TMsgDlgButtons() << mbOK, 0);
}
// EndCode
// EndExample: TStringBuilder
//---------------------------------------------------------------------------
