//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TTabSheetPageControl.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TTabSheetPageControl
// Property: Controls.TControl.Align
// Property: ComCtrls.TTabSheet.PageControl
// Property: ComCtrls.TPageControl.Create

// BeginCode
/*
This example dynamically creates a Page Control, then a
series of Tab Sheets on the Page Control.
*/
#include <Comctrls.hpp>
TPageControl* ppc;
const int MAXTABS = 3;
TTabSheet* pts[MAXTABS];
const char * ppcTabTitles[] = { "ShortString", "Orders", "Items", "Parts" };
int iTabTitles = sizeof(ppcTabTitles)/sizeof(ppcTabTitles[0]);
const TColor colorPalette[12] = {
  clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
  clTeal, clNavy, clMaroon, clLime, clOlive, clPurple};

void __fastcall TForm1::FormCreate(TObject *Sender)
{
	ppc = new TPageControl(this); // The owner (this) will clean this up.
	ppc->Parent = this;
	ppc->Align = alClient;
	for (int i=0;i<iTabTitles;i++)
  {
		pts[i] = new TTabSheet(this); // The owner (this) will clean this up.
		pts[i]->PageControl = ppc;
		pts[i]->Name = AnsiString("pts") + ppcTabTitles[i];
		pts[i]->Caption = ppcTabTitles[i];
		pts[i]->Brush->Color = colorPalette[i];
  }
}
// EndCode
// EndExample: TTabSheetPageControl
//---------------------------------------------------------------------------
