/*
Align, PageControl, TPageControl example
This example dynamically creates a Page Control, then a series of Tab Sheets on the Page Control.
*/
#include <Comctrls.hpp>
TPageControl* ppc;
TTabSheet* pts[MAXTABS];
const char * ppcTabTitles[] = { "ShortString", "Orders", "Items", "Parts" };
int iTabTitles = sizeof(ppcTabTitles)/sizeof(ppcTabTitles[0]);
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	ppc = new TPageControl(this);
	ppc->Parent = this;
	ppc->Align = alClient;
	for (int i=0;i<iTabTitles;i++)
  {
		pts[i] = new TTabSheet(this);
		pts[i]->PageControl = ppc;
		pts[i]->Name = AnsiString("pts") + ppcTabTitles[i];
        pts[i]->Caption = ppcTabTitles[i];
  }
}
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  for (int i=0;i<iTabTitles;i++)
    	delete pts[i];
	delete ppc;
}
 
