//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TThreadPriority.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

// BeginExample: TThreadPriority
// Method: Classes.TThread.Create
// Property: Classes.TThread.Priority
// Property: Classes.TThread.FreeOnTerminate
// Method: Classes.TThread.Resume
// Method: Classes.TThread.Execute

// BeginCode
/*
This example shows how to create a thread and start it
running at a lower priority than the main execution thread.
Set the threads FreeOnTerminate property is True, so that
there is no need to free the thread when it finishes. To
create the extension choose the
File | New | Other | Thread Object menu.
*/
bool mythreadRunning;
bool youthreadRunning;

class TMyThread : public TThread
{
__published:	// IDE-managed Components
private:	// User declarations
protected:  // User declarations
	void __fastcall Execute();
public:		// User declarations
	__fastcall TMyThread(bool suspended);
};

__fastcall TMyThread::TMyThread(bool suspended)
	: TThread(suspended)
{
}

class TYouThread : public TThread
{
__published:	// IDE-managed Components
private:	// User declarations
protected:  // User declarations
	void __fastcall Execute();
public:		// User declarations
	__fastcall TYouThread(bool suspended);
};

__fastcall TYouThread::TYouThread(bool suspended)
	: TThread(suspended)
{
}

void __fastcall TMyThread::Execute()
{
  Form1->Memo1->Lines->Add("Process has been running for this many seconds:");
  for (int I = 0; I <= 10; I++)
  {
	Form1->Memo1->Lines->Add("Low priority process " + IntToStr(I));
	Sleep(1000);
  }
  mythreadRunning = FALSE;
}

void __fastcall TYouThread::Execute()
{
  Form1->Memo3->Lines->Add("Second low priority process has been running for this many seconds:");
  for (int I = 0; I <= 10; I++)
  {
	Form1->Memo3->Lines->Add("Second low priority process " + IntToStr(I));
	Sleep(1000);
  }
  youthreadRunning = FALSE;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TMyThread *SecondProcess; // TMyThread is a custom descendant of TThread
  if (mythreadRunning == FALSE)
  {
	mythreadRunning = TRUE;
	SecondProcess = new TMyThread(True); // create suspended  secondprocess does not run yet
	SecondProcess->FreeOnTerminate = True; // don't need to cleanup after terminate
	SecondProcess->Priority = tpLower;  // set the priority to lower than normal
	SecondProcess->Resume(); // now run the thread
  }
  else
	MessageDlg("This thread is still running.  You are going to hurt yourself!",
	  mtInformation, TMsgDlgButtons() << mbOK, 0);
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  Form1->Memo2->Lines->Add("Do some work in the main process for 10 seconds:");
  for (int I = 0; I <= 10; I++)
  {
	Form1->Memo2->Lines->Add("Main process " + IntToStr(I));
    Sleep(1000);
  }
}

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  TYouThread *SecondProcess; // TMyThread is a custom descendant of TThread
  if (youthreadRunning == FALSE)
  {
	youthreadRunning = TRUE;
	SecondProcess = new TYouThread(True); // create suspended  secondprocess does not run yet
	SecondProcess->FreeOnTerminate = True; // don't need to cleanup after terminate
	SecondProcess->Priority = tpLower;  // set the priority to lower than normal
	SecondProcess->Resume(); // now run the thread
  }
  else
	MessageDlg("This thread is still running.  You are going to hurt yourself!",
	  mtInformation, TMsgDlgButtons() << mbOK, 0);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  mythreadRunning = FALSE;
  youthreadRunning = FALSE;
}
// EndCode
// EndExample: TThreadPriority
//---------------------------------------------------------------------------

