//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TToolButton.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TToolButtonCreate
// Method: ComCtrls.TToolButton.Create
// Method: ComCtrls.TToolBar.Create
// Property: Controls.TControl.Caption
// Property: ComCtrls.TToolButton.Style
// Property: ComCtrls.TToolBar.ButtonCount
// Property: ComCtrls.TToolBar.ShowCaptions

// BeginCode
/*
This example creates a ToolBar and adds ToolButtons to it.
Include ComCtlrs in the uses clause.
*/
#include <comctrls.hpp>
#include <memory>

void AddButtons(TToolBar *toolBar, TStringList *captions)
{
  for (int i = 0; i < captions->Count; i++)
  {
	TToolButton *button = new TToolButton(toolBar);  // The owner (toolBar) will clean this up.
	button->Parent = toolBar;
	button->Caption = captions->Strings[i];
	if (button->Caption == "|")
	  button->Style = tbsSeparator;
    else
	  button->Style = tbsButton;
  }
}

TToolBar *myToolBar;

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  myToolBar = new TToolBar(this); // The owner (this) will clean this up.
  myToolBar->Parent = this;
//  TStringList *captions = new TStringList();
  std::auto_ptr<TStringList> captions(new TStringList());

  captions->Add("New");
  captions->Add("Save");
  captions->Add("|");
  captions->Add("Cut");
  captions->Add("Copy");
  captions->Add("Paste");
  AddButtons(myToolBar, captions.get());
//  delete captions;
  myToolBar->ShowCaptions = True;
  myToolBar->Height = 40;
}
// EndCode
// EndExample: TToolButtonCreate
//---------------------------------------------------------------------------

