//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TTreeGetNodeAt.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TTreeGetNodeAt
// Method: ComCtrls.TCustomTreeView.GetNodeAt
// Method: ComCtrls.TTreeNode.MoveTo
// Property: ComCtrls.TCustomTreeView.Selected
// Method: ComCtrls.TCustomTreeView.GetHitTestInfoAt
// Property: Controls.TControl.DragMode
// Enumeration: ComCtrls.THitTests

// BeginCode
/*
The following code uses GetNodeAt to add a dragged node as a
child of the node under the mouse when it is dropped.  This
example requires a populated TreeView.  Also, the TTreeView
DragMode property set to dmAutomatic, and the TTreeView
OnDragOver event handler must be implemented to accept the
drop.
*/
void __fastcall TForm1::TreeView1DragDrop(TObject *Sender, TObject *Source,
      int X, int Y)
{
  if (Source != dynamic_cast<TObject *>(TreeView1) || TreeView1->Selected == NULL)
    return;
  THitTests HT = TreeView1->GetHitTestInfoAt(X, Y);
  TNodeAttachMode AttachMode;
  TTreeNode *Item = TreeView1->GetNodeAt(X, Y);
  if (HT.Contains(htOnItem) || HT.Contains(htOnIcon))
	AttachMode = naAddChild;
  else if (HT.Contains(htNowhere))
    AttachMode = naAdd;
  else if (HT.Contains(htOnIndent))
    AttachMode = naInsert;
  else
	return;
  TreeView1->Selected->MoveTo(Item, AttachMode);
}

void __fastcall TForm1::TreeView1DragOver(TObject *Sender, TObject *Source,
	  int X, int Y, TDragState State, bool &Accept)
{
  Accept = (Source == dynamic_cast<TObject *>(TreeView1));
}
// EndCode
// EndExample: TTreeGetNodeAt
//---------------------------------------------------------------------------
