/*
OnCustomDraw, Canvas, Bitmap, StretchDraw example
The following example shows how the OnCustomDraw event handler draws the background for the tree view before the items and lines are drawn.
*/ 
void __fastcall TCustomDrawForm::TVCustomDraw(TCustomTreeView *Sender, const TRect ARect, bool &DefaultDraw)
{
//This event should be used to draw any background colors or images.
//ARect represents the entire client area of the TreeView.
//Use the TreeView's canvas to do the drawing.
//Note that drawing a background bitmap is not really supported by CustomDraw,
//so scrolling can get messy. Best to subclass the TreeView and handle scrolling
//messages.
  TCanvas *pCanvas = TreeView1->Canvas;
  if (None1->Checked) //no picture
  {
    pCanvas->Brush->Color = BkgColorDialog->Color;
    pCanvas->Brush->Style = FBrushStyle;
    pCanvas->FillRect(ARect);
  }
  else
  {
    if (Tile1->Checked) //tile bitmap
    {
      pCanvas->Brush->Bitmap = Image1->Picture->Bitmap;
      pCanvas->FillRect(ARect);
    }
    else //Stretch across the canvas.
      pCanvas->StretchDraw(ARect, Image1->Picture->Bitmap);
  }
  DefaultDraw = FDefaultDraw;
  //setting DefaultDraw to false here prevents all calls to OnCustomDrawItem.
} 
