/*
OnCustomDrawItem, DisplayRect, Level, Indent example
The following example shows how the OnCustomDrawItem event handler draws items and lines of the tree view after the OnCustomDraw event handler has filled in the background.
*/ 
void __fastcall TCustomDrawForm::TVCustomDrawItem(TCustomTreeView *Sender, TTreeNode *Node, TCustomDrawState State, bool &DefaultDraw)
{
  TRect NodeRect;
  //If DefaultDraw it is true, any of the node's font properties can be
  //changed. Note also that when DefaultDraw is true, Windows draws the
  //buttons and ignores our font background colors, using instead the
  //TreeView's Color property.
  if (State.Contains(cdsSelected))
  {
    TV->Canvas->Font->Assign(SelectedFontDialog->Font);
    TV->Canvas->Brush->Color = SelBkgColorDialog->Color;
  }
  DefaultDraw = FDefaultDrawItem;
  //DefaultDraw = False means you have to handle all the item drawing yourself,
  //including the buttons, lines, images, and text.
  if (!DefaultDraw)
  {
    //draw the selection rect.
    if (State.Contains(cdsSelected))
    {
      NodeRect = Node->DisplayRect(true);
      TV->Canvas->FillRect(NodeRect);
    }
    NodeRect = Node->DisplayRect(false);
    if (None1->Checked)
    {
      //no bitmap, so paint in the background color.
      TV->Canvas->Brush->Color = BkgColorDialog->Color;
      TV->Canvas->Brush->Style = FBrushStyle;
      TV->Canvas->FillRect(NodeRect)
    }
    else  //don't paint over the background bitmap.
      TV->Canvas->Brush->Style = bsClear;
    NodeRect->Left = NodeRect->Left + (Node->Level * TV->Indent);
    //NodeRect.Left now represents the left-most portion of the expand button
    TV->Canvas->DrawButton(NodeRect, Node);
    NodeRect->Left = NodeRect->Left + TV->Indent + FButtonSize;
    //NodeRect.Left is now the leftmost portion of the image.
    TV->Canvas->DrawImage(NodeRect, Node->ImageIndex);
    NodeRect->Left = NodeRect->Left + ImageList->Width;
    //Now we are finally in a position to draw the text.
    TV->Canvas->TextOut(NodeRect->Left, NodeRect->Top, Node->Text);
  }
} 
