//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TabControlChange.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TabControlChange
// Property: ComCtrls.TCustomTabControl.Tabs
// Property: ComCtrls.TCustomTabControl.TabIndex
// Property: ComCtrls.TCustomTabControl.OnChange
// Method: Classes.TStrings.Assign
// Property: Classes.TStrings.Add
// Property: Dialogs.TOpenDialog.FileName
// Property: Dialogs.TOpenDialog.Files

// BeginCode
/*
This example uses a tab control to display the contents of
several files. To run the example, place a tab control on a
form and add a memo control that fits into its client area.
Be sure to leave enough room for the tabs when they appear.
Then add an OpenDialog and a button to the form.  The
"Add a file" button adds a single file to the tabcontrol.
The "Assign files" button removes previous files and can be
used to assign multiple files.  To assign multiple files,
use CNTL Select or SHIFT Select to select files in the
OpenDialog.
*/
void __fastcall TForm1::Add_a_fileClick(TObject *Sender)
{
  OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist << ofHideReadOnly;
  if (OpenDialog1->Execute())
  {
	int index = TabControl1->Tabs->Add(OpenDialog1->FileName);
	Memo1->Lines->LoadFromFile(TabControl1->Tabs->Strings[index]);
	TabControl1Change(Sender);
  }
}

void __fastcall TForm1::Assign_filesClick(TObject *Sender)
{
  OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist << ofHideReadOnly;
  if (OpenDialog1->Execute())
  {
	TabControl1->Tabs->Assign(OpenDialog1->Files);
	Memo1->Lines->LoadFromFile(TabControl1->Tabs->Strings[TabControl1->TabIndex]);
  }
}
/*
Place the following code in the tab controls OnChange event
handler:
*/
void __fastcall TForm1::TabControl1Change(TObject *Sender)
{
	Memo1->Lines->LoadFromFile(
	  TabControl1->Tabs->Strings[TabControl1->TabIndex]);
}
// EndCode
// EndExample: TabControlChange
//---------------------------------------------------------------------------
