
(*
 Delphi Object and Component Reference
#{bmc bm9.BMP} Tabs, TabIndex, OnChange, Assign example
This example uses a tab control to display the contents of several files. To run the example, place a tab control on a form and add a memo control that fits into its client area. Be sure to leave enough room for the tabs when they appear. Then add an OpenDialog and a button to the form.
Place the following code in the buttons OnClick event handler:
On Windows:
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist << ofHideReadOnly;
  if (OpenDialog1->Execute())
  {
    TabControl1->Tabs->Assign(OpenDialog1->Files);
    	Memo1->Lines->LoadFromFile(TabControl1->Tabs->Strings[TabControl1->TabIndex]);
  }
}
On Cross-platform:
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int i;
  OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
  if (OpenDialog1->Execute())
  {
    TabControl1->Tabs->Clear();
    for (i = 0; i < OpenDialog1->Files->Count; i++)
      TabControl1->Tabs->Add(OpenDialog1->Files->Strings[i]);
    TabControl1Change(Sender);
  }
}
Place the following code in the tab controls OnChange event handler:
*) 
void __fastcall TForm1::TabControl1Change(TObject *Sender)
{
    Memo1->Lines->LoadFromFile(TabControl1->Tabs->Strings[TabControl1->TabIndex]->Caption);
} 
