//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TabSheetPageControl.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TabSheetPageControl
// Property: ComCtrls.TTabSheet.PageControl
// Method: ComCtrls.TPageControl.FindNextPage
// Event: ComCtrls.TCustomTabControl.OnChange
// Class: ComCtrls.TPageControl

// BeginCode
/*
This example requires a new TPageControl, with no new pages
created at design time.  The form OnCreate event handler
adds several new TabSheet controls to the Page Control.  The
Page Controls OnChange event handler displays a message
dialog when the user changes tabs.  The message dialog
contains the captions for the tabs immediately before and
after the active tab.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  for (int i = 0; i < 10; i++)
  {
	TTabSheet *pPage = new TTabSheet(PageControl1); // These tabsheets will be cleaned up by their owner (PageControl1).
    pPage->PageControl = PageControl1;
    pPage->Caption = AnsiString("Page") + IntToStr(i);
    pPage->Name = AnsiString("ts") + pPage->Caption;
  }
}

void __fastcall TForm1::PageControl1Change(TObject *Sender)
{
  AnsiString PrevCaption, NextCaption;
  TPageControl *pPC = dynamic_cast<TPageControl *>(Sender);
  PrevCaption = pPC->FindNextPage(pPC->ActivePage, false, false)->Caption;
  NextCaption = pPC->FindNextPage(pPC->ActivePage, true, false)->Caption;
  ShowMessage(AnsiString("Previous tab caption: '") + PrevCaption +
    AnsiString("'  Next tab Caption: '") + NextCaption + AnsiString("'"));
}
// EndCode
// EndExample: TabSheetPageControl
//---------------------------------------------------------------------------
