
(*
 Delphi Object and Component Reference
#{bmc bm9.BMP} PageControl, FindNextPage, OnChange example
This example requires a new TPageControl, as-is, with no new pages created at design time.  
The form OnCreate event handler adds several new TabSheet controls to the Page Control.  The Page Controls OnChange event handler displays a message dialog when the user changes tabs.  The message dialog contains the captions for the tabs immediately before and after the active tab.
*) 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  for (int i = 0; i < 10; i++)
  {
    TTabSheet *pPage = new TTabSheet(PageControl1);
    pPage->PageControl = PageControl1;
    pPage->Caption = AnsiString("Page") + IntToStr(i);
    pPage->Name = AnsiString("ts") + pPage->Caption;
  }
}
void __fastcall TForm1::PageControl1Change(TObject *Sender)
{
  AnsiString PrevCaption, NextCaption;
  TPageControl!AL(`tpagecontrol_object',1,`TopicNotFound',`main') *pPC = (TPageControl *)Sender;
  PrevCaption = pPC->FindNextPage(pPC->ActivePage, true, false)->Caption;
  NextCaption = pPC->FindNextPage(pPC->ActivePage, false, false)->Caption;
  ShowMessage(AnsiString("Previous tab caption: '") + PrevCaption + AnsiString("'  Next tab Caption: '") + NextCaption + AnsiString("'"));
}
 
