//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TabVisible.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TabVisible
// Property: ComCtrls.TTabSheet.PageIndex
// Property: ComCtrls.TTabSheet.TabIndex
// Property: ComCtrls.TTabSheet.TabVisible
// Method: ComCtrls.TTabSheet.Create

// BeginCode
/*
This example creates ten Tab Sheets and sets the captions to
display PageIndex and TabIndex for each tab.  Odd numbered
tabs have their TabVisible property set off to demonstrate
the effect on PageIndex vs TabIndex.  On the series of
visible tabs, PageIndex will read 0, 2, 4, 6, 8, and
TabIndex will read 0, 1, 2, 3, 4.  PageIndex counts only
visible tabs.
*/
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  const TColor colorPalette[12] = {
	clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
	clTeal, clNavy, clMaroon, clLime, clOlive, clPurple};
  PageControl1->MultiLine = true;
  for (int i = 0; i < 10; i++)
  {
	TTabSheet *page = new TTabSheet(this); // These tabsheets will be cleaned up by their owner (this).
	page->PageControl = PageControl1;
	page->TabVisible = (i % 2 == 0);
	page->Caption =
	  AnsiString("PageIndex: ") + IntToStr(page->PageIndex) +
	  AnsiString("  TabIndex: ") + IntToStr(page->TabIndex);
	page->Brush->Color = colorPalette[i];
  }
}
// EndCode
// EndExample: TabVisible
//---------------------------------------------------------------------------
