/*
PageIndex, TabIndex, TabVisible example
This example creates ten Tab Sheets and sets the captions to display PageIndex and TabIndex for each tab.  Odd numbered tabs have their TabVisible property set off to demonstrate the effect on PageIndex vs TabIndex.  On the series of visible tabs, PageIndex will read 0, 2, 4, 6, 8, and TabIndex will read 0, 1, 2, 3, 4.  PageIndex counts only visible tabs.
*/ 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  PageControl1->MultiLine = true;
  for (int i = 0; i < 10; i++)
  {
    TTabSheet *pPage = new TTabSheet(this);
    pPage->PageControl = PageControl1;
    pPage->TabVisible = (i % 2 == 0);
    pPage->Caption = AnsiString("PageIndex: ") + IntToStr(pPage->PageIndex) + AnsiString("  TabIndex: ") + IntToStr(pPage->TabIndex);
  }
}
 
