//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TreeNodeAddChildObject.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TreeNodeAddChildObject
// Method: ComCtrls.TTreeNodes.AddChildObject

// BeginCode
/*
The following example adds a new child to the selected
items list of child items in the tree view control. The new
item is identified by the text New Item. The TBitmap
object is attached to the new item.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Graphics::TBitmap *MyBitMap =
	new Graphics::TBitmap();
  MyBitMap->LoadFromFile("..\\littleB16.bmp");
  TreeView1->Items->BeginUpdate(); // keep the node from painting until it's built
  TreeView1->Items->AddChildObject(
  TreeView1->Selected, "New Item", MyBitMap);
  TreeView1->Items->EndUpdate();
}
// EndCode
// EndExample: TreeNodeAddChildObject
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeView1CustomDrawItem(TCustomTreeView *Sender,
      TTreeNode *Node, TCustomDrawState State, bool &DefaultDraw)
{
  DefaultDraw = (Node->Data == NULL);
//  DefaultDraw = True;
  if (!DefaultDraw) {
	Graphics::TBitmap *bitmap = reinterpret_cast<Graphics::TBitmap *>(Node->Data);
	TRect NodeRect = Node->DisplayRect(True);
	Sender->Canvas->FillRect(NodeRect);
	Sender->Canvas->Draw(NodeRect.Left, NodeRect.Top, bitmap);
	NodeRect.Left = NodeRect.Left + bitmap->Width;
	Sender->Canvas->TextOut(NodeRect.Left, NodeRect.Top, Node->Text);
  }
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  for (int i = 0; i < 100; i++)
  {
	TTreeNode *node = TreeView1->Items->Item[i];
	if (node == NULL) continue;
	if (node->Text != "New Item") continue;
	TRect NodeRect = node->DisplayRect(True);
	Memo1->Lines->Add(
	  "Node " + IntToStr(i) + ": " +
	  " left: " + IntToStr(int(NodeRect.Left)) +
	  " right: " + IntToStr(int(NodeRect.Right)) +
	  " top: " + IntToStr(int(NodeRect.Top)) +
	  " bottom: " + IntToStr(int(NodeRect.Bottom)) + ".\n");
	Memo1->Lines->Add("Data: " + IntToStr(int(node->Data)) + ".\n");
  }
}
//---------------------------------------------------------------------------

