//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TreeNodeCustomSort.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TreeNodeCustomSort
// Method: ComCtrls.TTreeNode.CustomSort

// BeginCode
/*
This example shows how to use the CustomSort method to order
a subtree in case-insensitive alphabetical order (either
forward or backward). The callback function CompareFunc
below calls the global AnsiStrIComp function to perform the
actual comparison.  This example requires two buttons and a
populated TreeView.
*/
int CALLBACK CompareFunc(long lParam1, long lParam2, long Reverse)
{
  TTreeNode *Node1 = reinterpret_cast<TTreeNode *>(lParam1);
  TTreeNode *Node2 = reinterpret_cast<TTreeNode *>(lParam2);
  if ((Node1 == NULL) || (Node2 == NULL)) return 0;
  int GT = AnsiStrIComp(Node1->Text.c_str(), Node2->Text.c_str());
  if (Reverse)
    return -GT;
  return GT;
}

/*
This procedure can then be used as a parameter to CustomSort
to sort the nodes of the tree view.  To sort in ascending
order, call:
*/

#include <CommCtrl.hpp>

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TTreeNode *node = TreeView1->Selected;
  node->CustomSort(CompareFunc, 0); // Sorts in ascending order
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  TTreeNode *node = TreeView1->Selected;
  node->CustomSort(CompareFunc, 1); // Sorts in descending order
}
// EndCode
// EndExample: TreeNodeCustomSort
//---------------------------------------------------------------------------

