/*
CustomSort example
This example shows how to use the CustomSort method to order a tree view in case-insensitive alphabetical order (either forward or backward). The application must provide a callback function such as CompareFunc below, which calls the global AnsiStrIComp function to perform the actual comparison.
*/ 
int __fastcall CompareFunc(TTreeNode *Node1,TTreeNode *Node2, int Reverse)
{
  int GT = AnsiStrIComp(Node1->Text.c_str(), Node2->Text.c_str());
  if (Reverse)
    return -GT;
  return GT;
}
This procedure can then be used as a parameter to CustomSort to sort the nodes of the tree view.  To sort in ascending order, call
TreeView1->CustomSort((CommCtrl::TTVCompare)CompareFunc, 0);
To sort in descending order, call
TreeView1->CustomSort((CommCtrl::TTVCompare)CompareFunc, 1);
 
