//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TreeNodesAddObject.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: TreeNodesAddObject
// Method: ComCtrls.TTreeNodes.AddObject
// Property: ComCtrls.TTreeNodes.Count
// Property: ComCtrls.TTreeNode.Data
// Property: ComCtrls.TCustomTreeView.Selected
// Property: ComCtrls.TTreeNode.AbsoluteIndex

// BeginCode
/*
This example requires two buttons, three TEdits, a label and
a populated TreeView.  The following code defines a record
type of TMyRec and a record pointer type of PMyRec.
*/
typedef struct MyRec
{
  AnsiString FName, LName;
} TMyRec;

typedef TMyRec* PMyRec;
/*
Assuming these types are used, the following code adds a
node to TreeView1 as the last sibling of the node specified
by the Index.  A TMyRec record is associated with the added
item. The FName and LName fields are obtained from edit
boxes Edit1 and Edit2. The Index parameter is obtained from
edit box Edit3.  The item is added only if the Index is a
valid value.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int TreeViewIndex;
  TTreeNodes* items;

  // MyRecPtr will be added as an object to the treeview, so it's OK for MyRecPtr to be deleted in this proc.
  std::auto_ptr<TMyRec> MyRecPtr(new TMyRec);
  MyRecPtr->FName = Edit1->Text;
  MyRecPtr->LName = Edit2->Text;
  TreeViewIndex = StrToInt(Edit3->Text);
  items = TreeView1->Items;
  if (items->Count == 0)
	items->AddObject(NULL, "Item" + IntToStr(TreeViewIndex), MyRecPtr.get());
  else if ((TreeViewIndex < items->Count) && (TreeViewIndex >= 0))
	items->AddObject(
	  items->Item[TreeViewIndex],
	  "Item" + IntToStr(TreeViewIndex) + "after" + items->Item[TreeViewIndex]->Text,
	  MyRecPtr.get());
}
/*
After an item containing a TMyRec record has been added, the
following code retrieves the FName and LName values
associated with the item and displays the values in a label.
*/
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (TreeView1->Selected->Data != NULL)
	Label1->Caption = PMyRec(TreeView1->Selected->Data)->FName + " " +
				 PMyRec(TreeView1->Selected->Data)->LName;
}

TTreeNode *currentNode = NULL;

void __fastcall TForm1::Button3Click(TObject *Sender)
{
//  PMyRec  MyRecPtr;
  TTreeNodes* items;

//  MyRecPtr = new TMyRec;
  // MyRecPtr will be added as an object to the treeview, so it's OK for MyRecPtr to be deleted in this proc.
  std::auto_ptr<TMyRec> MyRecPtr(new TMyRec);
  MyRecPtr->FName = Edit1->Text;
  MyRecPtr->LName = Edit2->Text;
  items = TreeView1->Items;
  if (currentNode != NULL)
	items->AddObject(currentNode, Edit4->Text + " after " + currentNode->Text, MyRecPtr.get());
}

void __fastcall TForm1::TreeView1MouseDown(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
  THitTests HT;
  if (Sender->ClassNameIs("TTreeView"))
  {
	TTreeView *pTV = dynamic_cast<TTreeView *>(Sender);
	HT = pTV->GetHitTestInfoAt(X,Y);
    if (HT.Contains(htOnItem))
	  currentNode = pTV->GetNodeAt(X,Y);
  }
}

void __fastcall TForm1::Button4Click(TObject *Sender)
{
  if (currentNode != NULL)
	Label2->Caption = IntToStr(currentNode->AbsoluteIndex);
}
// EndCode
// EndExample: TreeNodesAddObject

