/*
AddObject, Count, Data example
The following code defines a structure type of TMyRec and a pointer type of PMyRec.
*/ 
typedef struct MyRec
{
  AnsiString FName, LName;
} TMyRec;
typedef TMyRec* PMyRec;
/*
Assuming these types are used, the following code adds a node to TreeView1 as the last sibling of a specified node. A TMyRec record is associated with the added item. The FName and LName fields are obtained from edit boxes Edit1 and Edit2. The Index parameter is obtained from edit box Edit3. The item is added only if the Index is a valid value.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
PMyRec  MyRecPtr;
int TreeViewIndex;
TTreeNodes* pItems;

 MyRecPtr = new TMyRec;
 MyRecPtr->FName = Edit1->Text;
 MyRecPtr->LName = Edit2->Text;
 TreeViewIndex = StrToInt(Edit3->Text);
 pItems = TreeView1->Items;
 if (pItems->Count == 0)
   pItems->AddObject(NULL, "Item" + IntToStr(TreeViewIndex), MyRecPtr);
 else if ((TreeViewIndex < pItems->Count) && (TreeViewIndex >= 0))
      pItems->AddObject(pItems->Item[TreeViewIndex], "Item" + IntToStr(TreeViewIndex), MyRecPtr);
}
/*
After an item containing a TMyRec record has been added, the following code retrieves the FName and LName values associated with the item and displays the values in a label.
*/ 
void __fastcall TForm1::Button2Click(TObject *Sender)
{
Label1->Caption = PMyRec(TreeView1->Selected->Data)->FName + " " +
                 PMyRec(TreeView1->Selected->Data)->LName;
} 
