//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UsingGUIDs.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: UsingGUIDs
// Routine: SysUtils.StringToGUID
// Routine: SysUtils.GUIDToString
// Routine: SysUtils.CreateGUID
// Routine: SysUtils.IsEqualGUID
// Type: System.TGUID
// Type: System.PGUID

// BeginCode
//
//This example demonstrates the usage of some GUID related routines along with
//the type itself.
//
void __fastcall TForm2::FormCreate(TObject *Sender)
{
	TGUID myGuid0, myGuid1;

	/* Create a new GUID from the string representation */
	myGuid0 = StringToGUID("{00020400-0000-0000-C000-000000000046}");
	Memo1->Lines->Add("The GUID is: " + GUIDToString(myGuid0));

	/*
	Accessing GUID's internal fields. Using Format function to
	obtain the same output as GUIDToString
	*/
	Memo1->Lines->Add(Format(String("GUID using formatting is: ") +
			   "{%0.8X-%0.4X-%0.4X-%0.2X%0.2X-%0.2X%0.2X%0.2X%0.2X%0.2X%0.2X}",
		 ARRAYOFCONST((myGuid0.Data1, myGuid0.Data2, myGuid0.Data3,
		 myGuid0.Data4[0], myGuid0.Data4[1], myGuid0.Data4[2], myGuid0.Data4[3],
		 myGuid0.Data4[4], myGuid0.Data4[5], myGuid0.Data4[6], myGuid0.Data4[7]))));

	/* Auto-generate a random GUID at runtime */
	if (CreateGUID(myGuid1) != 0)
		Memo1->Lines->Add("Creating GUID failed!");
	else
		Memo1->Lines->Add("The generated guid is: " + GUIDToString(myGuid1));

	/* Generating second random GUID */
	CreateGUID(myGuid0);

	/* Testing if 2 guids are equal */
	if (IsEqualGUID(myGuid0, myGuid1))
	   Memo1->Lines->Add("This cannot happen! CreateGUID guarantees that 2 " +
				String("randomly generated GUIDs cannot be equal!"));
}
// EndCode
// EndExample: UsingGUIDs

//---------------------------------------------------------------------------
