//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: VariantArrays
// Routine: Variants.VarArrayCreate
// Routine: Variants.VarArrayDimCount
// Routine: Variants.VarArrayLowBound
// Routine: Variants.VarArrayHighBound
// Routine: Variants.VarArrayPut
// Routine: Variants.VarArrayGet
// Routine: System.VarArrayRedim
// BeginCode
/*
This example demonstrates the use of variant arrays. In this
example a variant array is created, modified, populated and then freed.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	Variant array;
	int bounds[2] = {0, 9};

	/*
	Create a variant array of 10 elements, starting at 0
	and ending at 9. The array contains elements of type integer
	*/
	array = VarArrayCreate(bounds, 1, varInteger);

	// Increase the length of the variant array
	VarArrayRedim(array, 49);

	MessageDlg(String("Variant array has ") + IntToStr(VarArrayDimCount(array)) +
		" dimensions", mtInformation, TMsgDlgButtons() << mbOK, 0);

	// Traverse the array from lower to higher bounds
	for (int i = VarArrayLowBound(array, 1); i <= VarArrayHighBound(array, 1); i++)
	{
		// Put the element I at index I
		VarArrayPut(array, i, &i, 0);
	}

	// Now read the elements of the array
	for (int i = VarArrayLowBound(array, 1); i <= VarArrayHighBound(array, 1); i++)
	{
		// Put the element I at index I
		if (VarArrayGet(array, &i, 0) != i)
			MessageDlg("Error! Invalid element found at current position!",
				mtError, TMsgDlgButtons() << mbOK, 0);
	}

	// Clear the variant array
	VarClear(array);
}
// EndCode
// EndExample: VariantArrays
//---------------------------------------------------------------------------
